/*
 * @(#)Zip.java	1.0 98/12/11
 *
 * Java Project performed by
 *     Frank Moisant
 *    Patrick Titiano
 *        (ITRA3)
 *
 */


import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.FileDialog;

import java.io.File;

import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration;

import com.sun.java.swing.JFrame;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.SwingUtilities;
import com.sun.java.swing.ImageIcon;


/**
 * This class is the main program, it create the global action listener, the main panel, the menu bar
 * and a zip archive, without name
 * @see AllActionListener
 * @see ZipMainPanel
 * @see ZipMenuBar
 * @see ZipArchive
 * @see ZipSelectedAddFile
 * @see ZipDirectoryExtracting
 * @see ZipMessageBox
 * @version 1.0
 * @author Frank Moisant - Patrick Titiano
 */
public class Zip extends JFrame{
   
    // private members
    private AllActionListener allActionListener;
    private ZipMainPanel mainPanel;
    private ZipMenuBar menuBar;
    private ZipArchive zipArchive;


    /**
     * The Zip constructor, it construct the visual interface
     * @param title the title of the application
     */
    public Zip(String title) {
	super(title);

	// select the current look and feel
	selectStyle("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");

	// create all components, and add the to the panel of the JFrame
	allActionListener = new AllActionListener(this);
	mainPanel = new ZipMainPanel(allActionListener,this);
	menuBar = new ZipMenuBar(allActionListener);
	zipArchive = new ZipArchive();
	setJMenuBar(menuBar);
	getContentPane().add("Center", mainPanel);
	
	/**
	 * This class is used to activate the closing cross
	 * @version 1.0
	 * @author Frank Moisant - Patrick Titiano
	 */
	addWindowListener(new WindowAdapter() {

	    /**
	     * Use when window is closing
	     * @param e the window event
	     */
	    public void windowClosing(WindowEvent e) {System.exit(0);}
	});
	
	// display the JFrame
	pack();
	setSize(600,350);
	setVisible(true);
    }


    /**
     * Open a archive and set it as the current archive
     */
    public void openZipArchive() {
	
	// create a file dialog to chose the archive
	FileDialog fileDialog = new FileDialog(this,"Open Zip Archive",FileDialog.LOAD);
	fileDialog.show();

	// if file is selected
	if(fileDialog.getFile()!=null) {

	    // if the file is not a valid zip archive
	    if(!zipArchive.setArchiveName(fileDialog.getDirectory() + fileDialog.getFile())) {
		new ZipMessageBox(this,"Archive Error","The selected File is not a zip Archive");

		// the zip table is empty, and no active archive is selected
		Vector nullVector = new Vector();
		mainPanel.changeVectorOfDataVector(nullVector);
		mainPanel.enabledToolsAction(false);
		menuBar.enabledActionMenu(false);
		setTitle("Zip");
	    }
	    // if it is a good zip archive
	    else {
		// read the zipArchive and display the content, set the title as the archive name
		mainPanel.changeVectorOfDataVector(zipArchive.getTable());
		mainPanel.enabledToolsAction(true);
		menuBar.enabledActionMenu(true);
		setTitle(fileDialog.getDirectory() + fileDialog.getFile());
	    }
	}
    }


    /**
     * this method display a file dialog to chose the name of the archive
     * and create it, and display a file chooser dialog (ZipSelectedAddFile)
     */
    public void newZipArchive() {

	// create and display the file dialog
	FileDialog fileDialog = new FileDialog(this,"New Zip Archive",FileDialog.SAVE);
	fileDialog.show();

	// if a name is entered
	if(fileDialog.getFile()!=null) {

	    // construct the full name of the file
	    String fileName = fileDialog.getDirectory() + fileDialog.getFile();

	    // construct and display a the file chooser to compress
	    ZipSelectedAddFile addFile = new ZipSelectedAddFile(this);
	    Vector filesToAdd = addFile.getSelectedFiles();

	    // create the archive and add the selected file(s)
	    zipArchive.addFileToTheNewArchive(fileName,filesToAdd,addFile.positionInPathName);
	    mainPanel.changeVectorOfDataVector(zipArchive.getTable());
	    mainPanel.enabledToolsAction(true);
	    menuBar.enabledActionMenu(true);

	    setTitle(fileDialog.getDirectory() + fileDialog.getFile());
	}
    }
    

    /**
     * this method is called to extract all selected files in the current archive
     * display a ZipDirectoryExtracting to chose the directory to extract the
     * selected files
     */
    public void extractSelectedFiles() {

	// get the selected files in zipTable
	Vector toExtract = mainPanel.getSelectedFiles();

	// if files are selected
	if(toExtract.size() != 0) {

	    // display the dialog to have to location of the folder to decompress
	    ZipDirectoryExtracting zipDir = new ZipDirectoryExtracting(this);
	    if(!zipDir.canceled) {
		String pathToExtract = zipDir.getSelectedDirectory();
		zipArchive.extractFileFromTheArchive(toExtract,pathToExtract);
	    }
	}
    }


    /**
     * This method is use to delete all selected files in the zipTable
     */
    public void deleteSelectedFiles() {
	
	// get selected files
	Vector toDelete = mainPanel.getSelectedFiles();

	// if files are selected
	if(toDelete.size() != 0) {

	    // delete the files in the archive
	    zipArchive.deleteFilesFromArchive(toDelete);

	    // refresh the zipTable
	    mainPanel.changeVectorOfDataVector(zipArchive.getTable());
	    mainPanel.enabledToolsAction(true);
	    menuBar.enabledActionMenu(true);
	}
    }


    /**
     * Display a ZipSelecttedAddFile dialog to select the files to
     * add into the current archive
     */
    public void selectAndAddFiles() {

	// open the ZipSelectedAddFile dialog
	ZipSelectedAddFile addFile = new ZipSelectedAddFile(this);

	// get selected files
	Vector filesToAdd = addFile.getSelectedFiles();

	// add the files into the current archive
	zipArchive.addFileToTheArchive(filesToAdd,addFile.positionInPathName);

	// refresh the ZipTable
	mainPanel.changeVectorOfDataVector(zipArchive.getTable());
	mainPanel.enabledToolsAction(true);
	menuBar.enabledActionMenu(true);
    }


    /**
     * This method return if an archive is opened
     * @return true if an active archive exist
     */
    public boolean isFileSelected() {
	return zipArchive.isSelected();
    }


    /**
     * This method select all rows in the zipTable
     */
    public void selectAll() {
	mainPanel.selectAll();
    }


    /**
     * This method unselect selected rows
     */
    public void selectNone() {
	mainPanel.selectNone();
    }


    /**
     * This method is used to change the Look and Feel of the application
     * @param style the swing predefined look and file, Windows, Motif, or Metal
     */
    public void selectStyle(String style) {
	try {
	    UIManager.setLookAndFeel(style);
	    SwingUtilities.updateComponentTreeUI(this);
	} 
	catch (Exception e) {
	    System.out.println("No avaible Look and File");
	    e.printStackTrace();
	}
    }


    /**
     * The main programm, it just create an instance Zip object
     * @param argv the command line
     */
    public static void main(String argv[]) {
	Zip z = new Zip("Zip");
    }
}
